* likenorm_random.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Plot L(mu,sig2) for normal data vs. mu and sig2";
data likenorm;
	* Generate n random normal observations with parameters mu and sig2;
	%let n = 3;
	mu_true = 5; sig2_true = 0.25; sig_true = sqrt(sig2_true);
	array ydata (&n) y1-y&n;
	do i=1 to &n;
		ydata(i) = mu_true + sig_true*rannor(0);
	end;
	* Find likelihood as a function of mu and sig2;
	do mu=4 to 6 by 0.01;
		do sig2=0.05 to 0.5 by 0.01;
			sig = sqrt(sig2);
			Lmusig2 = 1;
			do i=1 to &n;
				Lmusig2 = Lmusig2*pdf('normal',ydata(i),mu,sig);
			end;
			output;
		end;
	end;
run;
* Print data, first 25 observations;
proc print data=likenorm(obs=25);
run;
* Plot likelihood as a function of mu and sig2;
* Contour plot version;
proc gcontour data=likenorm;
	plot sig2*mu=Lmusig2 / autolabel nolegend vaxis=axis1 haxis=axis1;
	symbol1 height=1.5 font=swissb width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
quit;
